using System;
using System.Data;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Windows.Forms;
using gov.va.med.vbecs.BOL;
using Microsoft.Reporting.WinForms;
using System.Reflection;
using System.IO;

namespace gov.va.med.vbecs.GUI
{
	/// <summary>
	/// Class FrmInappropriateRequestReport
	/// </summary>
    public class FrmInappropriateRequestReport : gov.va.med.vbecs.GUI.VbecsBaseForm /*: gov.va.med.vbecs.GUI.FrmBaseSinglePageReport*/
	{
		private InappropriateTransfusionRequestReport _reportData;
		private System.Windows.Forms.GroupBox grpImage;
		private System.Windows.Forms.PictureBox picImage;
        private gov.va.med.vbecs.GUI.controls.VbecsReportViewer rvInappropriateTransfusionRequest;
        private Button btnCancel;
        private Button btnPrint;
		private System.ComponentModel.IContainer components = null;
        DataSet _dsReport = new DataSet();

		/// <summary>
		/// Constructor
		/// </summary>
        public FrmInappropriateRequestReport(BOL.InappropriateTransfusionRequestReport inappropriateTransfusionRequestReport)
		{
			// This call is required by the Windows Form Designer.
			InitializeComponent();

			SetComponentProperties();
            this._reportData = inappropriateTransfusionRequestReport;
            this.CreateReport();
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
            System.ComponentModel.ComponentResourceManager resources = new System.ComponentModel.ComponentResourceManager(typeof(FrmInappropriateRequestReport));
            this.grpImage = new System.Windows.Forms.GroupBox();
            this.picImage = new System.Windows.Forms.PictureBox();
            this.rvInappropriateTransfusionRequest = new gov.va.med.vbecs.GUI.controls.VbecsReportViewer();
            this.btnCancel = new System.Windows.Forms.Button();
            this.btnPrint = new System.Windows.Forms.Button();
            ((System.ComponentModel.ISupportInitialize)(this.errError)).BeginInit();
            this.grpImage.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(this.picImage)).BeginInit();
            this.SuspendLayout();
            // 
            // vbecsLogo1
            // 
            this.vbecsLogo1.Title = " Inappropriate Transfusion Request Report";
            // 
            // grpImage
            // 
            this.grpImage.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left)));
            this.grpImage.Controls.Add(this.picImage);
            this.grpImage.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.grpImage.Location = new System.Drawing.Point(4, 32);
            this.grpImage.Name = "grpImage";
            this.grpImage.Size = new System.Drawing.Size(52, 406);
            this.grpImage.TabIndex = 44;
            this.grpImage.TabStop = false;
            // 
            // picImage
            // 
            this.picImage.Font = new System.Drawing.Font("Microsoft Sans Serif", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.picImage.Image = ((System.Drawing.Image)(resources.GetObject("picImage.Image")));
            this.picImage.Location = new System.Drawing.Point(4, 12);
            this.picImage.Name = "picImage";
            this.picImage.Size = new System.Drawing.Size(45, 45);
            this.picImage.SizeMode = System.Windows.Forms.PictureBoxSizeMode.AutoSize;
            this.picImage.TabIndex = 0;
            this.picImage.TabStop = false;
            // 
            // rvInappropriateTransfusionRequest
            // 
            this.rvInappropriateTransfusionRequest.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.rvInappropriateTransfusionRequest.Location = new System.Drawing.Point(60, 37);
            this.rvInappropriateTransfusionRequest.Name = "rvInappropriateTransfusionRequest";
            this.rvInappropriateTransfusionRequest.Size = new System.Drawing.Size(582, 401);
            this.rvInappropriateTransfusionRequest.TabIndex = 45;
            // 
            // btnCancel
            // 
            this.btnCancel.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
            this.btnCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
            this.btnCancel.Location = new System.Drawing.Point(564, 444);
            this.btnCancel.Name = "btnCancel";
            this.btnCancel.Size = new System.Drawing.Size(75, 23);
            this.btnCancel.TabIndex = 47;
            this.btnCancel.Text = "&Close";
            this.btnCancel.Click += new System.EventHandler(this.btnCancel_Click);
            // 
            // btnPrint
            // 
            this.btnPrint.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
            this.btnPrint.DialogResult = System.Windows.Forms.DialogResult.OK;
            this.btnPrint.Image = ((System.Drawing.Image)(resources.GetObject("btnPrint.Image")));
            this.btnPrint.ImageAlign = System.Drawing.ContentAlignment.MiddleLeft;
            this.btnPrint.Location = new System.Drawing.Point(484, 444);
            this.btnPrint.Name = "btnPrint";
            this.btnPrint.Size = new System.Drawing.Size(75, 23);
            this.btnPrint.TabIndex = 46;
            this.btnPrint.Text = "&Print";
            this.btnPrint.Click += new System.EventHandler(this.btnPrint_Click);
            // 
            // FrmInappropriateRequestReport
            // 
            this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
            this.ClientSize = new System.Drawing.Size(642, 473);
            this.Controls.Add(this.btnCancel);
            this.Controls.Add(this.btnPrint);
            this.Controls.Add(this.rvInappropriateTransfusionRequest);
            this.Controls.Add(this.grpImage);
            this.hlphelpChm.SetHelpKeyword(this, "Inappropriate_Transfusion_Request_Report.htm");
            this.hlphelpChm.SetHelpNavigator(this, System.Windows.Forms.HelpNavigator.Topic);
            this.Name = "FrmInappropriateRequestReport";
            this.RequiredFieldsLabel = true;
            this.hlphelpChm.SetShowHelp(this, true);
            this.Text = "VBECS - Inappropriate Transfusion Request Report";
            this.Load += new System.EventHandler(this.FrmInappropriateRequestReport_Load);
            this.Controls.SetChildIndex(this.vbecsLogo1, 0);
            this.Controls.SetChildIndex(this.lblRequiredField, 0);
            this.Controls.SetChildIndex(this.grpImage, 0);
            this.Controls.SetChildIndex(this.rvInappropriateTransfusionRequest, 0);
            this.Controls.SetChildIndex(this.btnPrint, 0);
            this.Controls.SetChildIndex(this.btnCancel, 0);
            ((System.ComponentModel.ISupportInitialize)(this.errError)).EndInit();
            this.grpImage.ResumeLayout(false);
            this.grpImage.PerformLayout();
            ((System.ComponentModel.ISupportInitialize)(this.picImage)).EndInit();
            this.ResumeLayout(false);
            this.PerformLayout();

		}
		#endregion

		private void SetComponentProperties()
		{
			this.vbecsLogo1.Title = this.Text.Replace("VBECS - ","");
			// CR 2693
			// hlpHelp
			// 
			this.hlpHelp.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 
			// hlphelpChm
			// 
			this.hlphelpChm.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			//
			this.SetThisHelpFile(this, Common.StrRes.HelpFiles.UC096.FrmInappropriateRequestReport());
            BOL.VbecsReport.SetUpReportButtons(this.rvInappropriateTransfusionRequest);
        }

        /// <summary>
        /// Create Report
        /// </summary>
        public void CreateReport()
        {
            _dsReport = this._reportData.GetReportData();
            DataSet dsHeader = BOL.VbecsReport.GetReportHeader(ThisUser.UserName);
            DataSet dsFooter = BOL.VbecsReport.GetReportFooter(this._reportData.GetReportCriteriaText());

/*#if DEBUG
            _dsReport.Tables[Common.DatabaseConstants.InappropriateTransfusionRequestReportDataUnits.InappropriateSurgicalRequestsTableName].WriteXml("e:\\temp\\InappropriateSurgicalRequests.xml", XmlWriteMode.WriteSchema);
            _dsReport.Tables[Common.DatabaseConstants.InappropriateTransfusionRequestReportDataUnits.InappropriateNonSurgicalRequestsTableName].WriteXml("e:\\temp\\InappropriateNonSurgicalRequests.xml", XmlWriteMode.WriteSchema);
            _dsReport.Tables[Common.DatabaseConstants.InappropriateTransfusionRequestReportDataUnits.DivisionMsbosRecommendationsTableName].WriteXml("e:\\temp\\DivisionMsbosRecommendations.xml", XmlWriteMode.WriteSchema);
            _dsReport.Tables[Common.DatabaseConstants.InappropriateTransfusionRequestReportDataUnits.DivisionTestingThresholdsTableName].WriteXml("e:\\temp\\DivisionTestingThresholds/*.xml", XmlWriteMode.WriteSchema);
#endif*/

            ReportDataSource reportSourceHeader = new ReportDataSource();
            if (dsHeader.Tables.Count > 0)
            {
                reportSourceHeader.Name = "ReportHeaderDataSet";
                reportSourceHeader.Value = dsHeader.Tables[0];
            }

            ReportDataSource reportSourceFooter = new ReportDataSource();
            if (dsFooter.Tables.Count > 0)
            {
                reportSourceFooter.Name = "ReportFooterDataSet";
                reportSourceFooter.Value = dsFooter.Tables[0];
            }

            Assembly assembly = Assembly.LoadFrom("Reports.dll");
            Stream stream = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.InappropriateTransfusionRequest.InappropriateTransfusionRequestReport.rdlc");
            Stream streamSurgical = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.InappropriateTransfusionRequest.InappropriateSurgicalRequests.rdlc");
            Stream streamNonSurgical = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.InappropriateTransfusionRequest.InappropriateNonSurgicalRequests.rdlc");
            Stream streamDivTesting = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.InappropriateTransfusionRequest.DivisionTestingThresholds.rdlc");
            Stream streamDivMsbos = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.InappropriateTransfusionRequest.DivisionMsbosRecommendations.rdlc");

            this.rvInappropriateTransfusionRequest.LocalReport.SubreportProcessing += new SubreportProcessingEventHandler(LoadSubreportsEventHandler);

            this.rvInappropriateTransfusionRequest.LocalReport.DataSources.Add(reportSourceHeader);
            this.rvInappropriateTransfusionRequest.LocalReport.DataSources.Add(reportSourceFooter);
            this.rvInappropriateTransfusionRequest.LocalReport.LoadReportDefinition(stream);
            this.rvInappropriateTransfusionRequest.LocalReport.LoadSubreportDefinition("InappropriateSurgicalRequests", streamSurgical);
            this.rvInappropriateTransfusionRequest.LocalReport.LoadSubreportDefinition("InappropriateNonSurgicalRequests", streamNonSurgical);
            this.rvInappropriateTransfusionRequest.LocalReport.LoadSubreportDefinition("DivisionTestingThresholds", streamDivTesting);
            this.rvInappropriateTransfusionRequest.LocalReport.LoadSubreportDefinition("DivisionMsbosRecommendations", streamDivMsbos);

            if (this._dsReport.Tables[Common.DatabaseConstants.InappropriateTransfusionRequestReportDataUnits.InappropriateSurgicalRequestsTableName].Rows.Count == 0)
                this.rvInappropriateTransfusionRequest.LocalReport.SetParameters(new ReportParameter("HideSurgical", "true"));
            else
                this.rvInappropriateTransfusionRequest.LocalReport.SetParameters(new ReportParameter("HideSurgical", "false"));

            if (this._dsReport.Tables[Common.DatabaseConstants.InappropriateTransfusionRequestReportDataUnits.InappropriateNonSurgicalRequestsTableName].Rows.Count == 0)
                this.rvInappropriateTransfusionRequest.LocalReport.SetParameters(new ReportParameter("HideNonSurgical", "true"));
            else
                this.rvInappropriateTransfusionRequest.LocalReport.SetParameters(new ReportParameter("HideNonSurgical", "false"));

            if (this._dsReport.Tables[Common.DatabaseConstants.InappropriateTransfusionRequestReportDataUnits.DivisionTestingThresholdsTableName].Rows.Count == 0)
                this.rvInappropriateTransfusionRequest.LocalReport.SetParameters(new ReportParameter("HideDivTesting", "true"));
            else
                this.rvInappropriateTransfusionRequest.LocalReport.SetParameters(new ReportParameter("HideDivTesting", "false"));

            if (this._dsReport.Tables[Common.DatabaseConstants.InappropriateTransfusionRequestReportDataUnits.DivisionMsbosRecommendationsTableName].Rows.Count == 0)
                this.rvInappropriateTransfusionRequest.LocalReport.SetParameters(new ReportParameter("HideDivMsbos", "true"));
            else
                this.rvInappropriateTransfusionRequest.LocalReport.SetParameters(new ReportParameter("HideDivMsbos", "false"));

            this.rvInappropriateTransfusionRequest.RefreshReport();

        }

        private void LoadSubreportsEventHandler(object sender, SubreportProcessingEventArgs e)
        {
            if (e.ReportPath == "InappropriateSurgicalRequests" || e.DataSourceNames[0].ToString() == "InappropriateSurgicalRequestsDataSet")
            {
                ReportDataSource reportSourceSurgical = new ReportDataSource();
                reportSourceSurgical.Name = "InappropriateSurgicalRequestsDataSet";
                reportSourceSurgical.Value = _dsReport.Tables[Common.DatabaseConstants.InappropriateTransfusionRequestReportDataUnits.InappropriateSurgicalRequestsTableName];
                e.DataSources.Add(reportSourceSurgical);
            }
            else if (e.ReportPath == "InappropriateNonSurgicalRequests" || e.DataSourceNames[0].ToString() == "InappropriateNonSurgicalRequestsDataSet")
            {
                ReportDataSource reportSourceNonSurgical = new ReportDataSource();
                reportSourceNonSurgical.Name = "InappropriateNonSurgicalRequestsDataSet";
                reportSourceNonSurgical.Value = _dsReport.Tables[Common.DatabaseConstants.InappropriateTransfusionRequestReportDataUnits.InappropriateNonSurgicalRequestsTableName];
                e.DataSources.Add(reportSourceNonSurgical);
            }
            else if (e.ReportPath == "DivisionTestingThresholds" || e.DataSourceNames[0].ToString() == "DivisionTestingThresholdDataSet")
            {
                ReportDataSource reportSourceDivisionTesting = new ReportDataSource();
                reportSourceDivisionTesting.Name = "DivisionTestingThresholdDataSet";
                reportSourceDivisionTesting.Value = _dsReport.Tables[Common.DatabaseConstants.InappropriateTransfusionRequestReportDataUnits.DivisionTestingThresholdsTableName];
                e.DataSources.Add(reportSourceDivisionTesting);
            }
            else if (e.ReportPath == "DivisionMsbosRecommendations" || e.DataSourceNames[0].ToString() == "DivisionMsbosRecommendationsDataSet")
            {
                ReportDataSource reportSourceDivisionMsbosRecommendations = new ReportDataSource();
                reportSourceDivisionMsbosRecommendations.Name = "DivisionMsbosRecommendationsDataSet";
                reportSourceDivisionMsbosRecommendations.Value = _dsReport.Tables[Common.DatabaseConstants.InappropriateTransfusionRequestReportDataUnits.DivisionMsbosRecommendationsTableName];
                e.DataSources.Add(reportSourceDivisionMsbosRecommendations);
            }
        }

        private void FrmInappropriateRequestReport_Load(object sender, EventArgs e)
        {

            this.rvInappropriateTransfusionRequest.RefreshReport();
        }

        private void btnCancel_Click(object sender, EventArgs e)
        {
            this.Close();
        }

        private void btnPrint_Click(object sender, EventArgs e)
        {
            //CR 3449
            try
            {
                this.rvInappropriateTransfusionRequest.PrintDialog();
            }
            catch (System.InvalidOperationException)
            {
            }
        }
	}
}

